{smcl}
{* documented: Oct 2021}{...}

{cmd:help eq5dmap} 

{hline}

{title:Title}

{cmd :eq5dmap} {hline 2} a command for mapping EQ-5D-3L and EQ-5D-5L.


{title:Syntax}


{p 8 14 2}
{cmd:eq5dmap} {newvar} {ifin} {weight}{cmd:,} {opt cov:ariates(varlist)}
[{it:{help eq5dmap##eq5dmap_options:eq5dmap_options}}]{p_end}

{synoptset 28 tabbed}{...}
{marker eq5dmap_options}{...}
{synopthdr :eq5dmap_options}
{synoptline}

{synopt :{opth cov:ariates(varlist)}}specifies the variables used as covariates: age and gender (see below). It is required.{p_end}
{synopt :{opt dire:ction(direction)}}specifies the direction to be used for the mapping. If omitted,
 the default is {opt 5->3}.{p_end}
{synopt :{opt values5(5Lvalueset)}}specifies the EQ-5D-5L value set. Supported options are: 
{opt UK} (United Kingdom); {opt JP} (Japan); {opt KO} (Korea); {opt NL} (The Netherlands); 
{opt CH} (China);  {opt SP} (Spain) and {opt GE} (Germany). If omitted,
 the default is {opt UK}. {p_end}

{synopt :{opth items(varlist)}}specifies the variables which contain observed values for the five EQ-5D 
domain items to map from. The list must contain 5 variables. {p_end}
{synopt :{opth score(varname)}}specifies a variable which contains the value of the EQ-5D utility score to map from. {p_end}
{synopt :{opt values3(3Lvalueset)}}specifies the EQ-5D-3L value set. Supported options are: 
{opt UK} (United Kingdom); {opt JP} (Japan); {opt KO} (Korea); {opt NL} (The Netherlands); 
{opt CH} (China);  {opt SP} (Spain) and {opt GE} (Germany). If omitted,
 the default is {opt UK}. {p_end}
{synopt :{opth bw:idth(#)}}specifies the bandwidth. The default is 0. {p_end}


{synoptline}
{p2colreset}{...}


{p 4 6 2}  {cmd:fweight}s, {cmd:iweight}s, and {cmd:aweight}s 
are allowed; see {help weight}.{p_end}



{title:Description}

{pstd}
{cmd:eq5dmap} is a community-contributed program which allows outcomes measured using the older 
EQ-5D-3L instrument to be converted into (expected) utility values
for the newer EQ-5D-5L and vice versa. Mapping can be carried 
out from the individual EQ-5D items or from a specified (exact or approximate) EQ-5D score. 
This newer version of the command is based on an updated analysis for mapping from EQ-5D-5L to EQ-5D-3L, using the same methods developed by
Hernández Alava and Pudney (2017) but based on a new large sample data collection (Hernandez Alava et al 2020) designed to overcome some of the limitations of the original datasets used in the first version of {cmd:eq5dmap}.


{title:Options for eq5dmap}

{phang}
{opth cov:ariates(varlist)} specifies the variables used as covariates. Mapping is age- and
 gender-specific, so there are two covariates. They must be specified as a {varlist} 
with the items ordered as: age; gender. Age can be coded a) in years: an integer in the interval [16,100] or b) as an age-band: an integer in the interval [1,5]  (1 = <35, 2 = [35, 45), 3 = [45, 55), 4 = [55, 65), 5 = [65 to 100)); gender should be coded as an integer, female = 0, male = 1

 {phang}
{opt dire:ction(direction)} specifies the mapping direction. The available options for {it:direction} are:
 {opt 3->5} and {opt 5->3}. If omitted, the default is {opt 3->5}.

{phang}
{opt values3:(3Lvalueset)} specifies one of the alternative EQ-5D-3L value sets offered. 
Current available options are UK (United Kingdom; Dolan 1997), JP (Japan; Tsuchiya et al 2002), 
 KO (Korea; Lee et al 2009), NL (the Netherlands; Lamers et al 2006), CH (China;Liu et al 2014), Spain (SP; Badia et al 2001) and GE (Germany; Claes et al 1999). 
 If omitted, the default is {opt UK}. This option is only used when 
EQ-5D-3L is the target outcome or when mapping from an EQ-5D-3L utility score.
 
{phang}
{opt values5:(5Lvalueset)} specifies one of the alternative EQ-5D-5L value sets offered. 
Current available options are UK (United Kingdom; Dolan 1997), JP (Japan; Shiroiwa et al 2016), 
 KO (Korea; Kim et al 2016), NL (the Netherlands; Versteegh et al 2016), CH (China;Luo et al 2017), Spain (SP; Ramos-Goñi et al 2018) and GE (Germany; Ludwig et al 2018). 
 If omitted, the default is {opt UK}.
This option is only used when EQ-5D-5L is the target outcome or when mapping 
from an EQ-5D-5L utility score.

{dlgtab:Predictor: set of variables for individual EQ-5D dimensions}

{phang}
{opt items(varlist)} specifies the variables which contain observed values for the five EQ-5D 
domain items to map from. They must be specified as a {it: varlist} containing five variables ordered as: 
mobility; self-care; usual activities; pain; anxiety/depression. The variables should all 
be coded on a scale 1,2,...,k (k=3 or 5) where 1 = best state, . . .,k = worst state. {p_end}

{dlgtab:Predictor: utility values for EQ-5D}

{phang}
{opth score(varname)} specifies a variable which contains the value of the EQ-5D 
utility score to map from.

{phang}
{opth bw:idth(#)} specifies the maximum distance to be allowed between the predictor 
value and any valid utility score. If omitted, the default is 0, which enforces 
exact matching of the predictor value to a point on the corresponding EQ-5D value set scale.



{title:Saved results}

{pstd}In addition to standard results saved by {cmd:summarize}
in {opt r()}, {cmd:EQ5Dmap} saves the following scalars and macros in {cmd:e()}:

{synoptset 20 tabbed}{...}
{p2col 5 20 24 2: Scalars}{p_end}
{synopt:{cmd:e(bwidth)}}bandwidth{p_end}


{synoptset 20 tabbed}{...}
{p2col 5 20 24 2: Macros}{p_end}
{synopt:{cmd:e(cmd)}}{cmd:eq5dmap}{p_end}
{synopt:{cmd:e(cmdline)}}command as typed{p_end}
{synopt:{cmd:e(model)}}name of model used for mapping: copula{p_end}
{synopt:{cmd:e(covariates)}}variables used as covariates{p_end}
{synopt:{cmd:e(direction)}}direction of the mapping{p_end}
{synopt:{cmd:e(values5)}}EQ-5D-5L value set{p_end}
{synopt:{cmd:e(values3)}}EQ-5D-3L value set {p_end}
{synopt:{cmd:e(items)}}variables for the five EQ-5D domain items{p_end}
{synopt:{cmd:e(score)}}variable containing the EQ-5D utility score{p_end}



{title:Examples}

{pstd}Predicting EQ-5D-3L (Dolan, 1997 UK value set) using the EQ-5D-5L item variables 
Y5_1 Y5_2 Y5_3 Y5_4 Y5_5 and age and male as covariates.{p_end}

{phang}{cmd:. eq5dmap E_Y3, cov(age male) items(Y5_1 Y5_2 Y5_3 Y5_4 Y5_5) }{p_end}

{pstd}Predicting EQ-5D-3L (Dolan, 1997 UK value set) using the EQ-5D-5L utility score
variable util5L, age and male as covariates and a bandwidth of 0.1.{p_end}

{phang}{cmd:. eq5dmap E_Y3mean5L, cov(age male) score(util5L)  bw(0.1) }{p_end}

{pstd}Predicting EQ-5D-3L (Dolan, 1997 UK value set) using the EQ-5D-5L Spanish utility score
variable util5L, age and male as covariates and a bandwidth of 0.1.{p_end}

{phang}{cmd:. eq5dmap E_Y3mean5L, cov(age male) score(util5L) values5(SP)  bw(0.1) }{p_end}


{pstd}Predicting EQ-5D-3L (Dolan, 1997 UK value set) using an exact EQ-5D-5L utility score
variable util5L, age and male as covariates.{p_end}

{phang}{cmd:. eq5dmap E_Y3mean5L, cov(age male) score(util5L) }{p_end}


{pstd}Predicting EQ-5D-5L (Devlin et al, 2018 English value set) using the EQ-5D-3L item variables 
Y3_1 Y3_2 Y3_3 Y3_4 Y3_5 and age and male as covariates.{p_end}

{phang}{cmd:. eq5dmap E_Y5, cov(age male) items(Y3_1 Y3_2 Y3_3 Y3_4 Y3_5) direction(3->5)} {p_end}


{title:References}

{p 4 8 2}Badia X, Roset R, Herdman, M, Kind P. (2001) A comparison of United Kingdom and Spanish general population time trade-off values for EQ-5D health states. Med Decis Making; 21(1): 7-16.

{p 4 8 2}Claes C, Greiner W, Uber A, Graf von der Schulenburg JM. (1999) An interview-based comparison of the TTO and VAS values given to EuroQol states of health by the general German population. n: Greiner W, J-M. Graf v.d. Schulenburg, Piercy J, editors. EuroQol Plenary Meeting, 1-2 October 1998. Discussion papers. Centre for Health Economics and Health Systems Research, University of Hannover, Germany. Uni-Verlag Witte, 13-39.

{p 4 8 2}Devlin, N., Shah, K., Feng, Y., Mulhern, B., and van Hout, B. (2018). Valuing health related
quality of life: An EQ-5D-5L value set for England. {it:Health Economics}, 27(1):7-22 {browse "http://onlinelibrary.wiley.com/doi/10.1002/hec.3564/full"}

{p 4 8 2}Dolan, P. (1997). Modeling valuations for EuroQol health states. {it:Medical Care}, 35:1095-1108.

{p 4 8 2}Hernández Alava M, Pudney S. (2017) Econometric modelling of multiple self-reports of health states:
The switch from EQ-5D-3L to EQ-5D-5L in evaluating drug therapies for rheumatoid arthritis. {it:Journal
of Health Economics), 55:139-152 

{p 4 8 2} Hernandez Alava, M., Pudney, S., and Wailoo, A. (2020) Estimating the relationship between EQ-5D-5L and EQ-5D-3L: results from an English Population Study. Policy Research Unit in Economic Evaluation of Health and Care Interventions. Universities of Sheffield and York. Report 063

{p 4 8 2}Kim SH, Ahn J, Ock M, Shin S, Park J, Luo N, Jo MW. (2016) The EQ-5D-5L valuation study in Korea. {it:Qual Life Res}, 25(7):1845-52

{p 4 8 2}Lamers LM, McDonnell J, Stalmeier PF, Krabbe PF, Busschbach JJ. (2006) The Dutch tariff: results and arguments for an effective design for national EQ-5D valuation studies. {it:Health Economics}, 15(10):1121-32.

{p 4 8 2}Lee YK, Nam HS, Chuang LH, Kim KY, Yang HK, Kwon IS, Kind P, Kweon SS, Kim YT. (2009) South Korean time trade-off values for EQ-5D health states: modeling with observed values for 101 health states. {it:Value Health}, 12(8):1187-93

{p 4 8 2}Liu GG, Wu H, Li M, Gao C, Luo N. (2014) Chinese time trade-off values for EQ-5D health states. {it:Value Health}, 17(5):597-604.

{p 4 8 2}Ludwig, K., Graf von der Schulenburg, JM. & Greiner, W. (2018) German Value Set for the EQ-5D-5L. {it:PharmacoEconomics}, 36:663–674.

{p 4 8 2}Luo N, Liu G, Li M, Guan H, Jin X, Rand-Hendriksen K. (2017) Estimating an EQ-5D-5L Value Set for China. {it:Value Health},20(4):662-669. 

{p 4 8 2}Ramos-Goñi JM, Craig B, Oppe M, Ramallo-Fariña Y, Pinto-Prades JL, Luo N, Rivero-Arias O. (2018) Handling data quality issues to estimate the Spanish EQ-5D-5L Value Set using a hybrid interval regression approach.  {it:Value in Health}, 21(5):596-604 In Press 

{p 4 8 2}Shiroiwa T, Ikeda S, Noto S, Igarashi A, Fukuda T, Saito S, Shimozuma K. (2016) Comparison of Value Set Based on DCE and/or TTO Data: Scoring for EQ-5D-5L Health States in Japan. {it:Value Health}, 19(5):648-54.

{p 4 8 2}Tsuchiya A, Ikeda S, Ikegami N, et al. (2002) Estimating an EQ-5D population value set: The case of Japan. {it:Health Economics}; 11(4):341-353.

{p 4 8 2}Versteegh MM, Vermeulen KM, Evers SM, de Wit GA, Prenger R, Stolk EA. (2016) Dutch Tariff for the Five-Level Version of EQ-5D. {it:Value Health}, 19(4):343-52.




{title:Authors}

{phang}Monica Hernandez-Alava, HEDS, ScHARR,University of Sheffield, UK.{p_end}
{phang}monica.hernandez@sheffield.ac.uk{p_end}
{phang}{browse "https://www.sheffield.ac.uk/scharr/people/staff/monica-hernandez-alava"}

{phang}Steve Pudney, HEDS, ScHARR,University of Sheffield, UK.{p_end}
{phang}steve.pudney@sheffield.ac.uk{p_end}
{phang}{browse "https://www.sheffield.ac.uk/scharr/people/staff/stephen-pudney"}

{phang}Allan Wailoo, HEDS, ScHARR,University of Sheffield, UK.{p_end}
{phang}a.j.wailoo@sheffield.ac.uk{p_end}
{phang}{browse "https://www.sheffield.ac.uk/scharr/people/staff/allan-wailoo"}


{title:Funding}

{pstd}This research is funded by the National Institute for Health Research (NIHR) Policy Research Programme,
conducted through the Policy Research Unit in Economic Methods of Evaluation in Health and Social Care
Interventions, PR-PRU-1217-20401. The first version of the eq5dmap command was supported by the National Institute for Health and Care Excellence with
its Decision Support Unit and the Medical Research Council (grant MR/L022575/1).
Pudney acknowledges further ESRC funding through the Centre for Micro-Social Change
(grant RES-518-28-5001). The views, and any errors or omissions, expressed in this document are of the authors only.{p_end}



